/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.apps.console;

import filenet.sim.apps.console.VWSIMConsoleCore;
import filenet.sim.toolkit.console.IVWSIMConsoleActionListener;
import filenet.sim.toolkit.console.IVWSIMConsoleStatusListener;
import filenet.sim.toolkit.console.VWSIMBaseNode;
import filenet.sim.toolkit.console.VWSIMConsoleActionCommand;
import filenet.sim.toolkit.console.VWSIMConsoleActionEvent;
import filenet.sim.toolkit.console.VWSIMConsoleStatusEvent;
import filenet.sim.toolkit.console.VWSIMScenarioNode;
import filenet.sim.toolkit.console.VWSIMSimulationNode;
import filenet.sim.toolkit.console.resources.VWSIMResource;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class VWSIMConsoleMenuBar
extends JMenuBar
implements IVWSIMConsoleActionListener,
IVWSIMConsoleStatusListener {
    public JMenu m_fileMenu = null;
    public JMenuItem m_exitItem = null;
    public JMenu m_viewMenu = null;
    public JCheckBoxMenuItem m_infoPaneItem = null;
    public JMenu m_toolsMenu = null;
    public JMenuItem m_scenarioDesignerItem = null;
    public JMenuItem m_animationViewerItem = null;
    public JMenu m_actionMenu = null;
    public JMenuItem m_mapFolderItem = null;
    public JMenuItem m_newScenarioItem = null;
    public JMenuItem m_openScenarioItem = null;
    public JMenuItem m_startSimulationItem = null;
    public JMenuItem m_stopSimulationItem = null;
    public JMenuItem m_viewAnimationItem = null;
    public JMenuItem m_viewScenarioItem = null;
    public JMenuItem m_deleteItem = null;
    public JMenuItem m_disconnectItem = null;
    public JMenuItem m_propertiesItem = null;
    public JMenuItem m_refreshItem = null;
    public JMenuItem m_upItem = null;
    public JMenuItem m_publishedData = null;
    public JMenuItem m_userPreferencesItem = null;
    public JMenu m_helpMenu = null;
    public JMenuItem m_helpTopicsItem = null;
    public JMenuItem m_aboutItem = null;
    private ActionListener m_listener = null;
    private VWSIMConsoleCore m_consoleCore = null;

    public VWSIMConsoleMenuBar(Container parent, ActionListener listener) {
        this.m_listener = listener;
        this.m_consoleCore = (VWSIMConsoleCore)listener;
    }

    public void consoleActionPerformed(VWSIMConsoleActionEvent evt) {
        VWSIMBaseNode baseNode = evt.getBaseNode();
        if (evt.setFocus()) {
            this.setMenuBar(baseNode);
        } else if (evt.updateToolbarMenubar()) {
            this.setMenuBar(baseNode);
        }
    }

    public void initMenuBar(boolean bViewInfoPane) {
        try {
            this.m_fileMenu = VWStringUtils.getMenuUsingString(VWSIMResource.File_HK);
            this.add(this.m_fileMenu);
            this.m_exitItem = VWStringUtils.getMenuItemUsingString(VWSIMResource.Exit_HK);
            this.m_exitItem.setActionCommand(VWSIMConsoleActionCommand.ACMD_EXIT);
            this.m_exitItem.addActionListener(this.m_listener);
            this.m_fileMenu.add(this.m_exitItem);
            this.m_viewMenu = VWStringUtils.getMenuUsingString(VWSIMResource.View_HK);
            this.add(this.m_viewMenu);
            this.m_infoPaneItem = VWStringUtils.getCheckBoxMenuItemUsingString(VWSIMResource.InfoPane);
            this.m_infoPaneItem.setSelected(bViewInfoPane);
            this.m_infoPaneItem.setActionCommand(VWSIMConsoleActionCommand.ACMD_INFO_PANE);
            this.m_infoPaneItem.addActionListener(this.m_listener);
            this.m_viewMenu.add(this.m_infoPaneItem);
            this.m_userPreferencesItem = VWStringUtils.getMenuItemUsingString(VWSIMResource.UserPreferences_HK);
            this.m_userPreferencesItem.setActionCommand(VWSIMConsoleActionCommand.ACMD_USER_PREFERENCES);
            this.m_userPreferencesItem.addActionListener(this.m_listener);
            this.m_viewMenu.addSeparator();
            this.m_viewMenu.add(this.m_userPreferencesItem);
            this.m_actionMenu = VWStringUtils.getMenuUsingString(VWSIMResource.Action_HK);
            this.add(this.m_actionMenu);
            this.m_mapFolderItem = VWStringUtils.getMenuItemUsingString(VWSIMResource.MapFolder_HK);
            this.m_mapFolderItem.setActionCommand(VWSIMConsoleActionCommand.ACMD_MAP_FOLDER);
            this.m_mapFolderItem.addActionListener(this.m_listener);
            this.m_actionMenu.add(this.m_mapFolderItem);
            this.m_publishedData = VWStringUtils.getMenuItemUsingString(VWSIMResource.PublishedData_HK);
            this.m_publishedData.setActionCommand(VWSIMConsoleActionCommand.ACMD_PUBLISHED_DATA);
            this.m_publishedData.addActionListener(this.m_listener);
            this.m_actionMenu.add(this.m_publishedData);
            this.m_actionMenu.addSeparator();
            this.m_newScenarioItem = VWStringUtils.getMenuItemUsingString(VWSIMResource.NewScenario_HK);
            this.m_newScenarioItem.setActionCommand(VWSIMConsoleActionCommand.ACMD_NEW_SCENARIO);
            this.m_newScenarioItem.addActionListener(this.m_listener);
            this.m_actionMenu.add(this.m_newScenarioItem);
            this.m_openScenarioItem = VWStringUtils.getMenuItemUsingString(VWSIMResource.OpenScenario_HK);
            this.m_openScenarioItem.setActionCommand(VWSIMConsoleActionCommand.ACMD_OPEN_SCENARIO);
            this.m_openScenarioItem.addActionListener(this.m_listener);
            this.m_actionMenu.add(this.m_openScenarioItem);
            this.m_startSimulationItem = VWStringUtils.getMenuItemUsingString(VWSIMResource.StartSimulation_HK);
            this.m_startSimulationItem.setActionCommand(VWSIMConsoleActionCommand.ACMD_RUN_SIMULATION);
            this.m_startSimulationItem.addActionListener(this.m_listener);
            this.m_actionMenu.add(this.m_startSimulationItem);
            this.m_actionMenu.addSeparator();
            this.m_stopSimulationItem = VWStringUtils.getMenuItemUsingString(VWSIMResource.StopSimulation_HK);
            this.m_stopSimulationItem.setActionCommand(VWSIMConsoleActionCommand.ACMD_STOP_SIMULATION);
            this.m_stopSimulationItem.addActionListener(this.m_listener);
            this.m_actionMenu.add(this.m_stopSimulationItem);
            this.m_viewAnimationItem = VWStringUtils.getMenuItemUsingString(VWSIMResource.ViewAnimation_HK);
            this.m_viewAnimationItem.setActionCommand(VWSIMConsoleActionCommand.ACMD_VIEW_ANIMATION);
            this.m_viewAnimationItem.addActionListener(this.m_listener);
            this.m_actionMenu.add(this.m_viewAnimationItem);
            this.m_viewScenarioItem = VWStringUtils.getMenuItemUsingString(VWSIMResource.ViewScenario_HK);
            this.m_viewScenarioItem.setActionCommand(VWSIMConsoleActionCommand.ACMD_VIEW_SCENARIO);
            this.m_viewScenarioItem.addActionListener(this.m_listener);
            this.m_actionMenu.add(this.m_viewScenarioItem);
            this.m_actionMenu.addSeparator();
            this.m_propertiesItem = VWStringUtils.getMenuItemUsingString(VWSIMResource.Properties_HK);
            this.m_propertiesItem.setActionCommand(VWSIMConsoleActionCommand.ACMD_PROPERTIES);
            this.m_propertiesItem.addActionListener(this.m_listener);
            this.m_actionMenu.add(this.m_propertiesItem);
            this.m_refreshItem = VWStringUtils.getMenuItemUsingString(VWSIMResource.Refresh_HK);
            this.m_refreshItem.setActionCommand(VWSIMConsoleActionCommand.ACMD_REFRESH);
            this.m_refreshItem.addActionListener(this.m_listener);
            this.m_actionMenu.add(this.m_refreshItem);
            this.m_disconnectItem = VWStringUtils.getMenuItemUsingString(VWSIMResource.Disconnect_HK);
            this.m_disconnectItem.setActionCommand(VWSIMConsoleActionCommand.ACMD_DISCONNECT_MAP_FOLDER);
            this.m_disconnectItem.addActionListener(this.m_listener);
            this.m_actionMenu.add(this.m_disconnectItem);
            this.m_deleteItem = VWStringUtils.getMenuItemUsingString(VWSIMResource.Delete_HK);
            this.m_deleteItem.setActionCommand(VWSIMConsoleActionCommand.ACMD_DELETE);
            this.m_deleteItem.addActionListener(this.m_listener);
            this.m_actionMenu.add(this.m_deleteItem);
            this.m_upItem = VWStringUtils.getMenuItemUsingString(VWSIMResource.Up_HK);
            this.m_upItem.setActionCommand(VWSIMConsoleActionCommand.ACMD_UP);
            this.m_upItem.addActionListener(this.m_listener);
            this.m_actionMenu.add(this.m_upItem);
            JMenu settingsMenu = this.m_consoleCore.getSettingsMenu(this);
            if (settingsMenu != null) {
                this.add(settingsMenu);
            }
            this.m_helpMenu = VWStringUtils.getMenuUsingString(VWSIMResource.Help_HK);
            this.add(this.m_helpMenu);
            this.m_helpTopicsItem = VWStringUtils.getMenuItemUsingString(VWSIMResource.HelpTopics_HK);
            this.m_helpTopicsItem.setActionCommand(VWSIMConsoleActionCommand.ACMD_HELP_TOPICS);
            this.m_helpTopicsItem.addActionListener(this.m_listener);
            this.m_helpMenu.add(this.m_helpTopicsItem);
            this.m_aboutItem = VWStringUtils.getMenuItemUsingString(VWSIMResource.AboutMenuItem_HK);
            this.m_aboutItem.setActionCommand(VWSIMConsoleActionCommand.ACMD_ABOUT);
            this.m_aboutItem.addActionListener(this.m_listener);
            this.m_helpMenu.add(this.m_aboutItem);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void consoleStatusChanged(VWSIMConsoleStatusEvent evt) {
        VWSIMBaseNode baseNode = evt.getBaseNode();
        try {
            int statusType = evt.getType();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void setMenuBar(VWSIMBaseNode aBaseNode) {
        if (aBaseNode.getIdmItem() == null) {
            this.m_propertiesItem.setEnabled(false);
        } else {
            this.m_propertiesItem.setEnabled(true);
        }
        switch (aBaseNode.getType()) {
            case 17: {
                this.setRootMenu();
                break;
            }
            case 16: {
                this.setFolderMenu();
                break;
            }
            case 18: {
                this.setTopFolderMenu();
                break;
            }
            case 33: {
                this.setScenarioMenu(aBaseNode);
                break;
            }
            case 34: {
                this.setSimulationMenu(aBaseNode);
            }
        }
    }

    private void setRootMenu() {
        this.m_actionMenu.removeAll();
        this.m_actionMenu.add(this.m_newScenarioItem);
        this.m_actionMenu.add(this.m_mapFolderItem);
        this.m_actionMenu.add(this.m_publishedData);
        if (this.m_actionMenu != null) {
            this.m_actionMenu.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        }
    }

    private void setTopFolderMenu() {
        this.m_actionMenu.removeAll();
        this.m_actionMenu.add(this.m_newScenarioItem);
        this.m_actionMenu.add(this.m_refreshItem);
        this.m_actionMenu.add(this.m_disconnectItem);
        this.m_actionMenu.add(this.m_upItem);
        if (this.m_actionMenu != null) {
            this.m_actionMenu.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        }
    }

    private void setFolderMenu() {
        this.m_actionMenu.removeAll();
        this.m_actionMenu.add(this.m_newScenarioItem);
        this.m_actionMenu.add(this.m_refreshItem);
        this.m_actionMenu.add(this.m_upItem);
        if (this.m_actionMenu != null) {
            this.m_actionMenu.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        }
    }

    private void setScenarioMenu(VWSIMBaseNode aBaseNode) {
        this.m_actionMenu.removeAll();
        VWSIMScenarioNode aScnNode = (VWSIMScenarioNode)aBaseNode;
        this.m_actionMenu.add(this.m_newScenarioItem);
        this.m_openScenarioItem.setEnabled(aScnNode.canViewContent());
        this.m_actionMenu.add(this.m_openScenarioItem);
        this.m_startSimulationItem.setEnabled(aScnNode.canViewContent());
        this.m_actionMenu.add(this.m_startSimulationItem);
        this.m_actionMenu.addSeparator();
        this.m_actionMenu.add(this.m_refreshItem);
        this.m_actionMenu.add(this.m_deleteItem);
        this.m_actionMenu.addSeparator();
        this.m_actionMenu.add(this.m_propertiesItem);
        if (this.m_actionMenu != null) {
            this.m_actionMenu.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        }
    }

    private void setSimulationMenu(VWSIMBaseNode aBaseNode) {
        this.m_actionMenu.removeAll();
        VWSIMSimulationNode aSimNode = (VWSIMSimulationNode)aBaseNode;
        this.m_actionMenu.add(this.m_newScenarioItem);
        this.m_actionMenu.addSeparator();
        if (aSimNode.getStatus() == 1) {
            this.m_stopSimulationItem.setEnabled(true);
        } else {
            this.m_stopSimulationItem.setEnabled(false);
        }
        this.m_actionMenu.add(this.m_stopSimulationItem);
        this.m_viewAnimationItem.setEnabled(aSimNode.canViewContent());
        this.m_actionMenu.add(this.m_viewAnimationItem);
        this.m_viewScenarioItem.setEnabled(aSimNode.canViewContent());
        this.m_actionMenu.add(this.m_viewScenarioItem);
        this.m_actionMenu.add(this.m_refreshItem);
        this.m_actionMenu.add(this.m_deleteItem);
        this.m_actionMenu.addSeparator();
        this.m_actionMenu.add(this.m_propertiesItem);
        if (this.m_actionMenu != null) {
            this.m_actionMenu.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        }
    }

    protected void releaseResources() {
        if (this.m_listener == null) {
            return;
        }
        if (this.m_fileMenu != null) {
            this.m_fileMenu.removeAll();
            this.m_fileMenu = null;
        }
        if (this.m_exitItem != null) {
            this.m_exitItem.removeActionListener(this.m_listener);
            this.m_exitItem = null;
        }
        if (this.m_viewMenu != null) {
            this.m_viewMenu.removeAll();
            this.m_viewMenu = null;
        }
        if (this.m_infoPaneItem != null) {
            this.m_infoPaneItem.removeActionListener(this.m_listener);
            this.m_infoPaneItem = null;
        }
        if (this.m_toolsMenu != null) {
            this.m_toolsMenu.removeAll();
            this.m_toolsMenu = null;
        }
        if (this.m_scenarioDesignerItem != null) {
            this.m_scenarioDesignerItem.removeActionListener(this.m_listener);
            this.m_scenarioDesignerItem = null;
        }
        if (this.m_animationViewerItem != null) {
            this.m_animationViewerItem.removeActionListener(this.m_listener);
            this.m_animationViewerItem = null;
        }
        if (this.m_actionMenu != null) {
            this.m_actionMenu.removeAll();
            this.m_actionMenu = null;
        }
        if (this.m_mapFolderItem != null) {
            this.m_mapFolderItem.removeActionListener(this.m_listener);
            this.m_mapFolderItem = null;
        }
        if (this.m_newScenarioItem != null) {
            this.m_newScenarioItem.removeActionListener(this.m_listener);
            this.m_newScenarioItem = null;
        }
        if (this.m_openScenarioItem != null) {
            this.m_openScenarioItem.removeActionListener(this.m_listener);
            this.m_openScenarioItem = null;
        }
        if (this.m_startSimulationItem != null) {
            this.m_startSimulationItem.removeActionListener(this.m_listener);
            this.m_startSimulationItem = null;
        }
        if (this.m_stopSimulationItem != null) {
            this.m_stopSimulationItem.removeActionListener(this.m_listener);
            this.m_stopSimulationItem = null;
        }
        if (this.m_viewAnimationItem != null) {
            this.m_viewAnimationItem.removeActionListener(this.m_listener);
            this.m_viewAnimationItem = null;
        }
        if (this.m_viewScenarioItem != null) {
            this.m_viewScenarioItem.removeActionListener(this.m_listener);
            this.m_viewScenarioItem = null;
        }
        if (this.m_deleteItem != null) {
            this.m_deleteItem.removeActionListener(this.m_listener);
            this.m_deleteItem = null;
        }
        if (this.m_disconnectItem != null) {
            this.m_disconnectItem.removeActionListener(this.m_listener);
            this.m_disconnectItem = null;
        }
        if (this.m_propertiesItem != null) {
            this.m_propertiesItem.removeActionListener(this.m_listener);
            this.m_propertiesItem = null;
        }
        if (this.m_refreshItem != null) {
            this.m_refreshItem.removeActionListener(this.m_listener);
            this.m_refreshItem = null;
        }
        if (this.m_upItem != null) {
            this.m_upItem.removeActionListener(this.m_listener);
            this.m_upItem = null;
        }
        if (this.m_publishedData != null) {
            this.m_publishedData.removeActionListener(this.m_listener);
            this.m_publishedData = null;
        }
        if (this.m_helpMenu != null) {
            this.m_helpMenu.removeAll();
            this.m_helpMenu = null;
        }
        if (this.m_helpTopicsItem != null) {
            this.m_helpTopicsItem.removeActionListener(this.m_listener);
            this.m_helpTopicsItem = null;
        }
        if (this.m_aboutItem != null) {
            this.m_aboutItem.removeActionListener(this.m_listener);
            this.m_aboutItem = null;
        }
        this.m_listener = null;
        this.removeAll();
    }
}

